/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jun  5 14:46:10 PDT 2016 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 32 -name t2_32 -include t.h */

/*
 * This function contains 488 FP additions, 350 FP multiplications,
 * (or, 236 additions, 98 multiplications, 252 fused multiply/add),
 * 183 stack variables, 7 constants, and 128 memory accesses
 */
#include "t.h"

static void t2_32(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + (mb * 8); m < me; m = m + 1, ri = ri + ms, ii = ii + ms, W = W + 8, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T7a, T7d, T9u, T9t;
	       {
		    E T2, T8, T3, T6, Te, Tr, T18, T4, Ta, Tz, T1n, T10, Ti, T5, Tc;
		    T2 = W[0];
		    T8 = W[4];
		    T3 = W[2];
		    T6 = W[3];
		    Te = W[6];
		    Tr = T2 * T8;
		    T18 = T3 * T8;
		    T4 = T2 * T3;
		    Ta = T2 * T6;
		    Tz = T3 * Te;
		    T1n = T8 * Te;
		    T10 = T2 * Te;
		    Ti = W[7];
		    T5 = W[1];
		    Tc = W[5];
		    {
			 E T34, T31, T2X, T2T, Tq, T46, T8H, T97, T4b, T8D, TH, T98, TZ, T7f, T4j;
			 E T6t, T1g, T7g, T4q, T6u, T4z, T6x, T1J, T7m, T7l, T8d, T6y, T4G, T2k, T7o;
			 E T7r, T8e, T6A, T4O, T6B, T4V, T6P, T5E, T7L, T3G, T6M, T61, T8n, T7I, T6I;
			 E T55, T7A, T2N, T6F, T5s, T8i, T7x, T5L, T62, T43, T7J, T5S, T63, T7O, T8o;
			 E T2U, T2R, T2V, T57, T3a, T5h, T2Y, T32, T35;
			 {
			      E T1K, T23, T1N, T26, T2b, T1U, T3C, T3j, T3z, T3f, T1R, T29, TR, Th, T2J;
			      E T2F, Td, TP, T3r, T3n, T2w, T2s, T3Q, T3M, T1Z, T1V, T2g, T2c;
			      {
				   E T11, T1C, TM, Tb, TJ, T7, T1o, T19, T1w, T1F, T15, T1s, T1d, T1z, TW;
				   E TS, Ty, T4a, T48, TG;
				   {
					E T1, TA, Ts, TE, Tw, Tn, Tj, T8G, Tk, To, T14;
					T1 = ri[0];
					TA = FMA(T6, Ti, Tz);
					T1K = FNMS(T6, Ti, Tz);
					T14 = T2 * Ti;
					{
					     E T1r, TD, T1c, Tv;
					     T1r = T8 * Ti;
					     TD = T3 * Ti;
					     T11 = FNMS(T5, Ti, T10);
					     T1C = FMA(T5, Ti, T10);
					     TM = FMA(T5, T3, Ta);
					     Tb = FNMS(T5, T3, Ta);
					     TJ = FNMS(T5, T6, T4);
					     T7 = FMA(T5, T6, T4);
					     T1o = FMA(Tc, Ti, T1n);
					     T23 = FMA(T6, Tc, T18);
					     T19 = FNMS(T6, Tc, T18);
					     T1w = FNMS(T5, Tc, Tr);
					     Ts = FMA(T5, Tc, Tr);
					     T1c = T3 * Tc;
					     Tv = T2 * Tc;
					     T1F = FNMS(T5, Te, T14);
					     T15 = FMA(T5, Te, T14);
					     T1s = FNMS(Tc, Te, T1r);
					     T1N = FMA(T6, Te, TD);
					     TE = FNMS(T6, Te, TD);
					     {
						  E T1T, T3i, T3e, T1Q;
						  T1T = TJ * Tc;
						  T3i = TJ * Ti;
						  T3e = TJ * Te;
						  T1Q = TJ * T8;
						  {
						       E Tg, T2I, T2E, T9;
						       Tg = T7 * Tc;
						       T2I = T7 * Ti;
						       T2E = T7 * Te;
						       T9 = T7 * T8;
						       {
							    E T3q, T3m, T2v, T2r;
							    T3q = T19 * Ti;
							    T3m = T19 * Te;
							    T2v = T1w * Ti;
							    T2r = T1w * Te;
							    {
								 E T2W, T2S, T3P, T3L;
								 T2W = T23 * Ti;
								 T2S = T23 * Te;
								 T3P = Ts * Ti;
								 T3L = Ts * Te;
								 T26 = FNMS(T6, T8, T1c);
								 T1d = FMA(T6, T8, T1c);
								 T1z = FMA(T5, T8, Tv);
								 Tw = FNMS(T5, T8, Tv);
								 T2b = FNMS(TM, T8, T1T);
								 T1U = FMA(TM, T8, T1T);
								 T3C = FNMS(TM, Te, T3i);
								 T3j = FMA(TM, Te, T3i);
								 T3z = FMA(TM, Ti, T3e);
								 T3f = FNMS(TM, Ti, T3e);
								 T1R = FNMS(TM, Tc, T1Q);
								 T29 = FMA(TM, Tc, T1Q);
								 TR = FNMS(Tb, T8, Tg);
								 Th = FMA(Tb, T8, Tg);
								 T34 = FMA(Tb, Te, T2I);
								 T2J = FNMS(Tb, Te, T2I);
								 T31 = FNMS(Tb, Ti, T2E);
								 T2F = FMA(Tb, Ti, T2E);
								 Td = FNMS(Tb, Tc, T9);
								 TP = FMA(Tb, Tc, T9);
								 T2X = FNMS(T26, Te, T2W);
								 T2T = FMA(T26, Ti, T2S);
								 T3r = FNMS(T1d, Te, T3q);
								 T3n = FMA(T1d, Ti, T3m);
								 T2w = FNMS(T1z, Te, T2v);
								 T2s = FMA(T1z, Ti, T2r);
								 T3Q = FNMS(Tw, Te, T3P);
								 T3M = FMA(Tw, Ti, T3L);
								 {
								      E T1Y, T1S, T2f, T2a;
								      T1Y = T1R * Ti;
								      T1S = T1R * Te;
								      T2f = T29 * Ti;
								      T2a = T29 * Te;
								      {
									   E Tm, Tf, TV, TQ;
									   Tm = Td * Ti;
									   Tf = Td * Te;
									   TV = TP * Ti;
									   TQ = TP * Te;
									   T1Z = FNMS(T1U, Te, T1Y);
									   T1V = FMA(T1U, Ti, T1S);
									   T2g = FNMS(T2b, Te, T2f);
									   T2c = FMA(T2b, Ti, T2a);
									   Tn = FNMS(Th, Te, Tm);
									   Tj = FMA(Th, Ti, Tf);
									   TW = FNMS(TR, Te, TV);
									   TS = FMA(TR, Ti, TQ);
									   T8G = ii[0];
								      }
								 }
							    }
						       }
						  }
					     }
					}
					Tk = ri[WS(rs, 16)];
					To = ii[WS(rs, 16)];
					{
					     E Tt, TF, Tu, T49, Tx, TB, T47, TC;
					     {
						  E Tl, T8E, Tp, T8F;
						  Tt = ri[WS(rs, 8)];
						  TF = ii[WS(rs, 24)];
						  Tl = Tj * Tk;
						  T8E = Tj * To;
						  Tu = Ts * Tt;
						  T49 = TA * TF;
						  Tp = FMA(Tn, To, Tl);
						  T8F = FNMS(Tn, Tk, T8E);
						  Tx = ii[WS(rs, 8)];
						  TB = ri[WS(rs, 24)];
						  Tq = T1 + Tp;
						  T46 = T1 - Tp;
						  T8H = T8F + T8G;
						  T97 = T8G - T8F;
						  T47 = Ts * Tx;
						  TC = TA * TB;
					     }
					     Ty = FMA(Tw, Tx, Tu);
					     T4a = FNMS(TE, TB, T49);
					     T48 = FNMS(Tw, Tt, T47);
					     TG = FMA(TE, TF, TC);
					}
				   }
				   {
					E TT, TX, TO, T4f, TU, T4g;
					{
					     E TK, TN, TL, T4e;
					     TK = ri[WS(rs, 4)];
					     TN = ii[WS(rs, 4)];
					     T4b = T48 - T4a;
					     T8D = T48 + T4a;
					     TH = Ty + TG;
					     T98 = Ty - TG;
					     TL = TJ * TK;
					     T4e = TJ * TN;
					     TT = ri[WS(rs, 20)];
					     TX = ii[WS(rs, 20)];
					     TO = FMA(TM, TN, TL);
					     T4f = FNMS(TM, TK, T4e);
					     TU = TS * TT;
					     T4g = TS * TX;
					}
					{
					     E T17, T4m, T1a, T1e, T4d, T4i;
					     {
						  E T12, T16, TY, T4h, T13, T4l;
						  T12 = ri[WS(rs, 28)];
						  T16 = ii[WS(rs, 28)];
						  TY = FMA(TW, TX, TU);
						  T4h = FNMS(TW, TT, T4g);
						  T13 = T11 * T12;
						  T4l = T11 * T16;
						  TZ = TO + TY;
						  T4d = TO - TY;
						  T7f = T4f + T4h;
						  T4i = T4f - T4h;
						  T17 = FMA(T15, T16, T13);
						  T4m = FNMS(T15, T12, T4l);
					     }
					     T4j = T4d + T4i;
					     T6t = T4i - T4d;
					     T1a = ri[WS(rs, 12)];
					     T1e = ii[WS(rs, 12)];
					     {
						  E T1m, T4u, T1H, T4E, T1x, T1A, T1u, T4w, T1y, T4B;
						  {
						       E T1D, T1G, T1E, T4D;
						       {
							    E T1f, T4o, T4k, T4p;
							    {
								 E T1j, T1l, T1b, T4n, T1k, T4t;
								 T1j = ri[WS(rs, 2)];
								 T1l = ii[WS(rs, 2)];
								 T1b = T19 * T1a;
								 T4n = T19 * T1e;
								 T1k = T7 * T1j;
								 T4t = T7 * T1l;
								 T1f = FMA(T1d, T1e, T1b);
								 T4o = FNMS(T1d, T1a, T4n);
								 T1m = FMA(Tb, T1l, T1k);
								 T4u = FNMS(Tb, T1j, T4t);
							    }
							    T1g = T17 + T1f;
							    T4k = T17 - T1f;
							    T7g = T4m + T4o;
							    T4p = T4m - T4o;
							    T1D = ri[WS(rs, 26)];
							    T1G = ii[WS(rs, 26)];
							    T4q = T4k - T4p;
							    T6u = T4k + T4p;
							    T1E = T1C * T1D;
							    T4D = T1C * T1G;
						       }
						       {
							    E T1p, T1t, T1q, T4v;
							    T1p = ri[WS(rs, 18)];
							    T1t = ii[WS(rs, 18)];
							    T1H = FMA(T1F, T1G, T1E);
							    T4E = FNMS(T1F, T1D, T4D);
							    T1q = T1o * T1p;
							    T4v = T1o * T1t;
							    T1x = ri[WS(rs, 10)];
							    T1A = ii[WS(rs, 10)];
							    T1u = FMA(T1s, T1t, T1q);
							    T4w = FNMS(T1s, T1p, T4v);
							    T1y = T1w * T1x;
							    T4B = T1w * T1A;
						       }
						  }
						  {
						       E T4A, T1v, T7j, T4x, T1B, T4C;
						       T4A = T1m - T1u;
						       T1v = T1m + T1u;
						       T7j = T4u + T4w;
						       T4x = T4u - T4w;
						       T1B = FMA(T1z, T1A, T1y);
						       T4C = FNMS(T1z, T1x, T4B);
						       {
							    E T1I, T4y, T4F, T7k;
							    T1I = T1B + T1H;
							    T4y = T1B - T1H;
							    T4F = T4C - T4E;
							    T7k = T4C + T4E;
							    T4z = T4x - T4y;
							    T6x = T4x + T4y;
							    T1J = T1v + T1I;
							    T7m = T1v - T1I;
							    T7l = T7j - T7k;
							    T8d = T7j + T7k;
							    T6y = T4A - T4F;
							    T4G = T4A + T4F;
						       }
						  }
					     }
					}
				   }
			      }
			      {
				   E T5Z, T3u, T5V, T5C, T7G, T5D, T3F, T5X, T4P, T4U;
				   {
					E T1P, T4J, T2i, T4T, T21, T4L, T28, T4R;
					{
					     E T1L, T1O, T1W, T20;
					     T1L = ri[WS(rs, 30)];
					     T1O = ii[WS(rs, 30)];
					     {
						  E T2d, T2h, T1M, T4I, T2e, T4S;
						  T2d = ri[WS(rs, 22)];
						  T2h = ii[WS(rs, 22)];
						  T1M = T1K * T1L;
						  T4I = T1K * T1O;
						  T2e = T2c * T2d;
						  T4S = T2c * T2h;
						  T1P = FMA(T1N, T1O, T1M);
						  T4J = FNMS(T1N, T1L, T4I);
						  T2i = FMA(T2g, T2h, T2e);
						  T4T = FNMS(T2g, T2d, T4S);
					     }
					     T1W = ri[WS(rs, 14)];
					     T20 = ii[WS(rs, 14)];
					     {
						  E T24, T27, T1X, T4K, T25, T4Q;
						  T24 = ri[WS(rs, 6)];
						  T27 = ii[WS(rs, 6)];
						  T1X = T1V * T1W;
						  T4K = T1V * T20;
						  T25 = T23 * T24;
						  T4Q = T23 * T27;
						  T21 = FMA(T1Z, T20, T1X);
						  T4L = FNMS(T1Z, T1W, T4K);
						  T28 = FMA(T26, T27, T25);
						  T4R = FNMS(T26, T24, T4Q);
					     }
					}
					{
					     E T22, T7p, T4M, T4N, T2j, T7q;
					     T4P = T1P - T21;
					     T22 = T1P + T21;
					     T7p = T4J + T4L;
					     T4M = T4J - T4L;
					     T4N = T28 - T2i;
					     T2j = T28 + T2i;
					     T7q = T4R + T4T;
					     T4U = T4R - T4T;
					     T2k = T22 + T2j;
					     T7o = T22 - T2j;
					     T7r = T7p - T7q;
					     T8e = T7p + T7q;
					     T6A = T4M + T4N;
					     T4O = T4M - T4N;
					}
				   }
				   {
					E T3l, T5z, T3E, T3v, T3t, T3w, T3x, T5B, T3A, T3B, T3D, T3y, T5W;
					{
					     E T3g, T3k, T3h, T5y;
					     T3g = ri[WS(rs, 31)];
					     T3k = ii[WS(rs, 31)];
					     T3A = ri[WS(rs, 23)];
					     T6B = T4P - T4U;
					     T4V = T4P + T4U;
					     T3h = T3f * T3g;
					     T5y = T3f * T3k;
					     T3B = T3z * T3A;
					     T3D = ii[WS(rs, 23)];
					     T3l = FMA(T3j, T3k, T3h);
					     T5z = FNMS(T3j, T3g, T5y);
					}
					{
					     E T3o, T5Y, T3s, T3p, T5A;
					     T3o = ri[WS(rs, 15)];
					     T3E = FMA(T3C, T3D, T3B);
					     T5Y = T3z * T3D;
					     T3s = ii[WS(rs, 15)];
					     T3p = T3n * T3o;
					     T3v = ri[WS(rs, 7)];
					     T5Z = FNMS(T3C, T3A, T5Y);
					     T5A = T3n * T3s;
					     T3t = FMA(T3r, T3s, T3p);
					     T3w = TP * T3v;
					     T3x = ii[WS(rs, 7)];
					     T5B = FNMS(T3r, T3o, T5A);
					}
					T3u = T3l + T3t;
					T5V = T3l - T3t;
					T3y = FMA(TR, T3x, T3w);
					T5W = TP * T3x;
					T5C = T5z - T5B;
					T7G = T5z + T5B;
					T5D = T3y - T3E;
					T3F = T3y + T3E;
					T5X = FNMS(TR, T3v, T5W);
				   }
				   {
					E T2L, T5q, T5m, T2z, T7v, T53, T2D, T5o;
					{
					     E T2q, T50, T2y, T2A, T2C, T52, T2B, T5n;
					     {
						  E T2G, T2K, T2n, T4Z, T2t, T51;
						  {
						       E T2o, T2p, T60, T7H;
						       T2n = ri[WS(rs, 1)];
						       T6P = T5C + T5D;
						       T5E = T5C - T5D;
						       T7L = T3u - T3F;
						       T3G = T3u + T3F;
						       T60 = T5X - T5Z;
						       T7H = T5X + T5Z;
						       T2o = T2 * T2n;
						       T2p = ii[WS(rs, 1)];
						       T6M = T5V - T60;
						       T61 = T5V + T60;
						       T8n = T7G + T7H;
						       T7I = T7G - T7H;
						       T4Z = T2 * T2p;
						       T2q = FMA(T5, T2p, T2o);
						  }
						  T2G = ri[WS(rs, 25)];
						  T2K = ii[WS(rs, 25)];
						  T50 = FNMS(T5, T2n, T4Z);
						  {
						       E T2x, T2u, T2H, T5p;
						       T2t = ri[WS(rs, 17)];
						       T2H = T2F * T2G;
						       T5p = T2F * T2K;
						       T2x = ii[WS(rs, 17)];
						       T2u = T2s * T2t;
						       T2L = FMA(T2J, T2K, T2H);
						       T5q = FNMS(T2J, T2G, T5p);
						       T51 = T2s * T2x;
						       T2y = FMA(T2w, T2x, T2u);
						  }
						  T2A = ri[WS(rs, 9)];
						  T2C = ii[WS(rs, 9)];
						  T52 = FNMS(T2w, T2t, T51);
					     }
					     T5m = T2q - T2y;
					     T2z = T2q + T2y;
					     T2B = T8 * T2A;
					     T5n = T8 * T2C;
					     T7v = T50 + T52;
					     T53 = T50 - T52;
					     T2D = FMA(Tc, T2C, T2B);
					     T5o = FNMS(Tc, T2A, T5n);
					}
					{
					     E T3N, T3K, T3O, T5G, T41, T5Q, T3R, T3U, T3W;
					     {
						  E T3H, T3I, T3J, T3Y, T40, T5F, T3Z, T5P;
						  T3H = ri[WS(rs, 3)];
						  {
						       E T54, T2M, T5r, T7w;
						       T54 = T2D - T2L;
						       T2M = T2D + T2L;
						       T5r = T5o - T5q;
						       T7w = T5o + T5q;
						       T6I = T53 + T54;
						       T55 = T53 - T54;
						       T7A = T2z - T2M;
						       T2N = T2z + T2M;
						       T6F = T5m - T5r;
						       T5s = T5m + T5r;
						       T8i = T7v + T7w;
						       T7x = T7v - T7w;
						       T3I = T3 * T3H;
						  }
						  T3J = ii[WS(rs, 3)];
						  T3Y = ri[WS(rs, 11)];
						  T40 = ii[WS(rs, 11)];
						  T3N = ri[WS(rs, 19)];
						  T3K = FMA(T6, T3J, T3I);
						  T5F = T3 * T3J;
						  T3Z = Td * T3Y;
						  T5P = Td * T40;
						  T3O = T3M * T3N;
						  T5G = FNMS(T6, T3H, T5F);
						  T41 = FMA(Th, T40, T3Z);
						  T5Q = FNMS(Th, T3Y, T5P);
						  T3R = ii[WS(rs, 19)];
						  T3U = ri[WS(rs, 27)];
						  T3W = ii[WS(rs, 27)];
					     }
					     {
						  E T2O, T2P, T2Q, T37, T39, T56, T38, T5g;
						  {
						       E T3T, T5K, T5I, T3X, T5O, T7M, T5J;
						       T2O = ri[WS(rs, 5)];
						       {
							    E T3S, T5H, T3V, T5N;
							    T3S = FMA(T3Q, T3R, T3O);
							    T5H = T3M * T3R;
							    T3V = Te * T3U;
							    T5N = Te * T3W;
							    T3T = T3K + T3S;
							    T5K = T3K - T3S;
							    T5I = FNMS(T3Q, T3N, T5H);
							    T3X = FMA(Ti, T3W, T3V);
							    T5O = FNMS(Ti, T3U, T5N);
							    T2P = T29 * T2O;
						       }
						       T7M = T5G + T5I;
						       T5J = T5G - T5I;
						       {
							    E T42, T5M, T7N, T5R;
							    T42 = T3X + T41;
							    T5M = T3X - T41;
							    T7N = T5O + T5Q;
							    T5R = T5O - T5Q;
							    T5L = T5J - T5K;
							    T62 = T5K + T5J;
							    T43 = T3T + T42;
							    T7J = T42 - T3T;
							    T5S = T5M + T5R;
							    T63 = T5M - T5R;
							    T7O = T7M - T7N;
							    T8o = T7M + T7N;
							    T2Q = ii[WS(rs, 5)];
						       }
						  }
						  T37 = ri[WS(rs, 13)];
						  T39 = ii[WS(rs, 13)];
						  T2U = ri[WS(rs, 21)];
						  T2R = FMA(T2b, T2Q, T2P);
						  T56 = T29 * T2Q;
						  T38 = T1R * T37;
						  T5g = T1R * T39;
						  T2V = T2T * T2U;
						  T57 = FNMS(T2b, T2O, T56);
						  T3a = FMA(T1U, T39, T38);
						  T5h = FNMS(T1U, T37, T5g);
						  T2Y = ii[WS(rs, 21)];
						  T32 = ri[WS(rs, 29)];
						  T35 = ii[WS(rs, 29)];
					     }
					}
				   }
			      }
			 }
			 {
			      E T5c, T5t, T5j, T5u, T88, T90, T8Z, T8b;
			      {
				   E T7e, T8T, T7y, T7D, T7h, T8U, T8s, T8v;
				   {
					E T8c, T1i, T8A, T8z, T8O, T8J, T8N, T2l, T8L, T45, T8t, T8l, T8u, T8q, T3c;
					E T8k, T8p, T8w, T2m;
					{
					     E T8x, T8y, T8j, T8C, T8I;
					     {
						  E TI, T30, T5b, T59, T36, T5f, T1h, T7B, T5a;
						  TI = Tq + TH;
						  T7e = Tq - TH;
						  {
						       E T2Z, T58, T33, T5e;
						       T2Z = FMA(T2X, T2Y, T2V);
						       T58 = T2T * T2Y;
						       T33 = T31 * T32;
						       T5e = T31 * T35;
						       T30 = T2R + T2Z;
						       T5b = T2R - T2Z;
						       T59 = FNMS(T2X, T2U, T58);
						       T36 = FMA(T34, T35, T33);
						       T5f = FNMS(T34, T32, T5e);
						       T1h = TZ + T1g;
						       T8T = T1g - TZ;
						  }
						  T7B = T57 + T59;
						  T5a = T57 - T59;
						  {
						       E T3b, T5d, T7C, T5i;
						       T3b = T36 + T3a;
						       T5d = T36 - T3a;
						       T7C = T5f + T5h;
						       T5i = T5f - T5h;
						       T5c = T5a - T5b;
						       T5t = T5b + T5a;
						       T3c = T30 + T3b;
						       T7y = T3b - T30;
						       T5j = T5d + T5i;
						       T5u = T5d - T5i;
						       T7D = T7B - T7C;
						       T8j = T7B + T7C;
						       T8c = TI - T1h;
						       T1i = TI + T1h;
						  }
					     }
					     T8k = T8i - T8j;
					     T8x = T8i + T8j;
					     T8y = T8n + T8o;
					     T8p = T8n - T8o;
					     T7h = T7f - T7g;
					     T8C = T7f + T7g;
					     T8I = T8D + T8H;
					     T8U = T8H - T8D;
					     T8A = T8x + T8y;
					     T8z = T8x - T8y;
					     T8O = T8I - T8C;
					     T8J = T8C + T8I;
					}
					{
					     E T8h, T8m, T3d, T44;
					     T8h = T2N - T3c;
					     T3d = T2N + T3c;
					     T44 = T3G + T43;
					     T8m = T3G - T43;
					     T8N = T2k - T1J;
					     T2l = T1J + T2k;
					     T8L = T44 - T3d;
					     T45 = T3d + T44;
					     T8t = T8k - T8h;
					     T8l = T8h + T8k;
					     T8u = T8m + T8p;
					     T8q = T8m - T8p;
					}
					T8w = T1i - T2l;
					T2m = T1i + T2l;
					{
					     E T8S, T8R, T8P, T8Q;
					     {
						  E T8r, T8M, T8K, T8g, T8B, T8f;
						  T8S = T8q - T8l;
						  T8r = T8l + T8q;
						  T8B = T8d + T8e;
						  T8f = T8d - T8e;
						  ri[0] = T2m + T45;
						  ri[WS(rs, 16)] = T2m - T45;
						  ri[WS(rs, 8)] = T8w + T8z;
						  ri[WS(rs, 24)] = T8w - T8z;
						  T8M = T8J - T8B;
						  T8K = T8B + T8J;
						  T8g = T8c + T8f;
						  T8s = T8c - T8f;
						  T8R = T8O - T8N;
						  T8P = T8N + T8O;
						  ii[WS(rs, 24)] = T8M - T8L;
						  ii[WS(rs, 8)] = T8L + T8M;
						  ii[WS(rs, 16)] = T8K - T8A;
						  ii[0] = T8A + T8K;
						  ri[WS(rs, 4)] = FMA(KP707106781, T8r, T8g);
						  ri[WS(rs, 20)] = FNMS(KP707106781, T8r, T8g);
						  T8Q = T8t + T8u;
						  T8v = T8t - T8u;
					     }
					     ii[WS(rs, 20)] = FNMS(KP707106781, T8Q, T8P);
					     ii[WS(rs, 4)] = FMA(KP707106781, T8Q, T8P);
					     ii[WS(rs, 28)] = FNMS(KP707106781, T8S, T8R);
					     ii[WS(rs, 12)] = FMA(KP707106781, T8S, T8R);
					}
				   }
				   {
					E T7P, T7W, T7i, T7K, T8a, T86, T91, T8V, T8W, T7t, T7T, T7F, T92, T7Z, T89;
					E T83;
					{
					     E T7X, T7n, T7s, T7Y, T84, T85;
					     T7P = T7L - T7O;
					     T84 = T7L + T7O;
					     ri[WS(rs, 12)] = FMA(KP707106781, T8v, T8s);
					     ri[WS(rs, 28)] = FNMS(KP707106781, T8v, T8s);
					     T7W = T7e + T7h;
					     T7i = T7e - T7h;
					     T85 = T7I + T7J;
					     T7K = T7I - T7J;
					     T7X = T7m + T7l;
					     T7n = T7l - T7m;
					     T8a = FMA(KP414213562, T84, T85);
					     T86 = FNMS(KP414213562, T85, T84);
					     T91 = T8U - T8T;
					     T8V = T8T + T8U;
					     T7s = T7o + T7r;
					     T7Y = T7o - T7r;
					     {
						  E T82, T81, T7z, T7E;
						  T82 = T7x + T7y;
						  T7z = T7x - T7y;
						  T7E = T7A - T7D;
						  T81 = T7A + T7D;
						  T8W = T7n + T7s;
						  T7t = T7n - T7s;
						  T7T = FNMS(KP414213562, T7z, T7E);
						  T7F = FMA(KP414213562, T7E, T7z);
						  T92 = T7Y - T7X;
						  T7Z = T7X + T7Y;
						  T89 = FNMS(KP414213562, T81, T82);
						  T83 = FMA(KP414213562, T82, T81);
					     }
					}
					{
					     E T7S, T7u, T93, T95, T7U, T7Q;
					     T7S = FNMS(KP707106781, T7t, T7i);
					     T7u = FMA(KP707106781, T7t, T7i);
					     T93 = FMA(KP707106781, T92, T91);
					     T95 = FNMS(KP707106781, T92, T91);
					     T7U = FMA(KP414213562, T7K, T7P);
					     T7Q = FNMS(KP414213562, T7P, T7K);
					     {
						  E T80, T87, T8X, T8Y;
						  T88 = FNMS(KP707106781, T7Z, T7W);
						  T80 = FMA(KP707106781, T7Z, T7W);
						  {
						       E T7V, T94, T96, T7R;
						       T7V = T7T + T7U;
						       T94 = T7U - T7T;
						       T96 = T7F + T7Q;
						       T7R = T7F - T7Q;
						       ri[WS(rs, 30)] = FMA(KP923879532, T7V, T7S);
						       ri[WS(rs, 14)] = FNMS(KP923879532, T7V, T7S);
						       ii[WS(rs, 22)] = FNMS(KP923879532, T94, T93);
						       ii[WS(rs, 6)] = FMA(KP923879532, T94, T93);
						       ii[WS(rs, 30)] = FMA(KP923879532, T96, T95);
						       ii[WS(rs, 14)] = FNMS(KP923879532, T96, T95);
						       ri[WS(rs, 6)] = FMA(KP923879532, T7R, T7u);
						       ri[WS(rs, 22)] = FNMS(KP923879532, T7R, T7u);
						       T87 = T83 + T86;
						       T90 = T86 - T83;
						  }
						  T8Z = FNMS(KP707106781, T8W, T8V);
						  T8X = FMA(KP707106781, T8W, T8V);
						  T8Y = T89 + T8a;
						  T8b = T89 - T8a;
						  ri[WS(rs, 2)] = FMA(KP923879532, T87, T80);
						  ri[WS(rs, 18)] = FNMS(KP923879532, T87, T80);
						  ii[WS(rs, 18)] = FNMS(KP923879532, T8Y, T8X);
						  ii[WS(rs, 2)] = FMA(KP923879532, T8Y, T8X);
					     }
					}
				   }
			      }
			      {
				   E T6s, T9o, T9n, T6v, T6N, T6Q, T6G, T6J, T6o, T6r;
				   {
					E T6c, T4s, T9c, T4X, T9h, T9b, T9i, T6f, T5U, T6l, T64, T5k, T5v;
					{
					     E T6d, T6e, T99, T9a, T5T;
					     {
						  E T4c, T4r, T4H, T4W;
						  T6s = T46 - T4b;
						  T4c = T46 + T4b;
						  ii[WS(rs, 26)] = FNMS(KP923879532, T90, T8Z);
						  ii[WS(rs, 10)] = FMA(KP923879532, T90, T8Z);
						  ri[WS(rs, 10)] = FMA(KP923879532, T8b, T88);
						  ri[WS(rs, 26)] = FNMS(KP923879532, T8b, T88);
						  T4r = T4j + T4q;
						  T9o = T4q - T4j;
						  T6d = FMA(KP414213562, T4z, T4G);
						  T4H = FNMS(KP414213562, T4G, T4z);
						  T4W = FMA(KP414213562, T4V, T4O);
						  T6e = FNMS(KP414213562, T4O, T4V);
						  T9n = T98 + T97;
						  T99 = T97 - T98;
						  T6c = FMA(KP707106781, T4r, T4c);
						  T4s = FNMS(KP707106781, T4r, T4c);
						  T9c = T4H + T4W;
						  T4X = T4H - T4W;
						  T9a = T6t + T6u;
						  T6v = T6t - T6u;
					     }
					     T6N = T5S - T5L;
					     T5T = T5L + T5S;
					     T9h = FNMS(KP707106781, T9a, T99);
					     T9b = FMA(KP707106781, T9a, T99);
					     T9i = T6e - T6d;
					     T6f = T6d + T6e;
					     T5U = FNMS(KP707106781, T5T, T5E);
					     T6l = FMA(KP707106781, T5T, T5E);
					     T64 = T62 + T63;
					     T6Q = T62 - T63;
					     T6G = T5j - T5c;
					     T5k = T5c + T5j;
					     T5v = T5t + T5u;
					     T6J = T5t - T5u;
					}
					{
					     E T68, T6m, T6q, T6j, T6p, T6b;
					     {
						  E T4Y, T6a, T66, T69, T5x, T9j, T9l, T6k, T65, T9k, T9m, T67;
						  T68 = FNMS(KP923879532, T4X, T4s);
						  T4Y = FMA(KP923879532, T4X, T4s);
						  T6k = FMA(KP707106781, T64, T61);
						  T65 = FNMS(KP707106781, T64, T61);
						  {
						       E T6i, T5l, T6h, T5w;
						       T6i = FMA(KP707106781, T5k, T55);
						       T5l = FNMS(KP707106781, T5k, T55);
						       T6h = FMA(KP707106781, T5v, T5s);
						       T5w = FNMS(KP707106781, T5v, T5s);
						       T6m = FNMS(KP198912367, T6l, T6k);
						       T6q = FMA(KP198912367, T6k, T6l);
						       T6a = FMA(KP668178637, T5U, T65);
						       T66 = FNMS(KP668178637, T65, T5U);
						       T6j = FMA(KP198912367, T6i, T6h);
						       T6p = FNMS(KP198912367, T6h, T6i);
						       T69 = FNMS(KP668178637, T5l, T5w);
						       T5x = FMA(KP668178637, T5w, T5l);
						  }
						  T9j = FMA(KP923879532, T9i, T9h);
						  T9l = FNMS(KP923879532, T9i, T9h);
						  T9k = T6a - T69;
						  T6b = T69 + T6a;
						  T9m = T5x + T66;
						  T67 = T5x - T66;
						  ii[WS(rs, 21)] = FNMS(KP831469612, T9k, T9j);
						  ii[WS(rs, 5)] = FMA(KP831469612, T9k, T9j);
						  ri[WS(rs, 5)] = FMA(KP831469612, T67, T4Y);
						  ri[WS(rs, 21)] = FNMS(KP831469612, T67, T4Y);
						  ii[WS(rs, 29)] = FMA(KP831469612, T9m, T9l);
						  ii[WS(rs, 13)] = FNMS(KP831469612, T9m, T9l);
					     }
					     {
						  E T9g, T9f, T9d, T9e, T6g, T6n;
						  T6o = FNMS(KP923879532, T6f, T6c);
						  T6g = FMA(KP923879532, T6f, T6c);
						  T6n = T6j + T6m;
						  T9g = T6m - T6j;
						  T9f = FNMS(KP923879532, T9c, T9b);
						  T9d = FMA(KP923879532, T9c, T9b);
						  ri[WS(rs, 29)] = FMA(KP831469612, T6b, T68);
						  ri[WS(rs, 13)] = FNMS(KP831469612, T6b, T68);
						  ri[WS(rs, 1)] = FMA(KP980785280, T6n, T6g);
						  ri[WS(rs, 17)] = FNMS(KP980785280, T6n, T6g);
						  T9e = T6p + T6q;
						  T6r = T6p - T6q;
						  ii[WS(rs, 17)] = FNMS(KP980785280, T9e, T9d);
						  ii[WS(rs, 1)] = FMA(KP980785280, T9e, T9d);
						  ii[WS(rs, 25)] = FNMS(KP980785280, T9g, T9f);
						  ii[WS(rs, 9)] = FMA(KP980785280, T9g, T9f);
					     }
					}
				   }
				   {
					E T6Y, T6w, T9w, T6D, T9v, T9p, T9q, T71, T6H, T74, T78, T7c, T6W, T6S;
					{
					     E T6Z, T6z, T6C, T70;
					     T6Z = FNMS(KP414213562, T6x, T6y);
					     T6z = FMA(KP414213562, T6y, T6x);
					     ri[WS(rs, 9)] = FMA(KP980785280, T6r, T6o);
					     ri[WS(rs, 25)] = FNMS(KP980785280, T6r, T6o);
					     T6Y = FNMS(KP707106781, T6v, T6s);
					     T6w = FMA(KP707106781, T6v, T6s);
					     T6C = FNMS(KP414213562, T6B, T6A);
					     T70 = FMA(KP414213562, T6A, T6B);
					     T9w = T6z + T6C;
					     T6D = T6z - T6C;
					     T9v = FNMS(KP707106781, T9o, T9n);
					     T9p = FMA(KP707106781, T9o, T9n);
					     {
						  E T77, T6O, T76, T6R;
						  T9q = T70 - T6Z;
						  T71 = T6Z + T70;
						  T77 = FMA(KP707106781, T6N, T6M);
						  T6O = FNMS(KP707106781, T6N, T6M);
						  T76 = FMA(KP707106781, T6Q, T6P);
						  T6R = FNMS(KP707106781, T6Q, T6P);
						  T6H = FNMS(KP707106781, T6G, T6F);
						  T74 = FMA(KP707106781, T6G, T6F);
						  T78 = FNMS(KP198912367, T77, T76);
						  T7c = FMA(KP198912367, T76, T77);
						  T6W = FMA(KP668178637, T6O, T6R);
						  T6S = FNMS(KP668178637, T6R, T6O);
					     }
					}
					{
					     E T6U, T6E, T9x, T9z, T73, T6K;
					     T6U = FNMS(KP923879532, T6D, T6w);
					     T6E = FMA(KP923879532, T6D, T6w);
					     T9x = FNMS(KP923879532, T9w, T9v);
					     T9z = FMA(KP923879532, T9w, T9v);
					     T73 = FMA(KP707106781, T6J, T6I);
					     T6K = FNMS(KP707106781, T6J, T6I);
					     {
						  E T72, T79, T9s, T9r;
						  T7a = FMA(KP923879532, T71, T6Y);
						  T72 = FNMS(KP923879532, T71, T6Y);
						  {
						       E T75, T7b, T6V, T6L;
						       T75 = FMA(KP198912367, T74, T73);
						       T7b = FNMS(KP198912367, T73, T74);
						       T6V = FNMS(KP668178637, T6H, T6K);
						       T6L = FMA(KP668178637, T6K, T6H);
						       {
							    E T9A, T9y, T6X, T6T;
							    T9A = T75 + T78;
							    T79 = T75 - T78;
							    T7d = T7b + T7c;
							    T9y = T7c - T7b;
							    T6X = T6V - T6W;
							    T9s = T6V + T6W;
							    T9u = T6S - T6L;
							    T6T = T6L + T6S;
							    ii[WS(rs, 31)] = FMA(KP980785280, T9A, T9z);
							    ii[WS(rs, 15)] = FNMS(KP980785280, T9A, T9z);
							    ii[WS(rs, 23)] = FNMS(KP980785280, T9y, T9x);
							    ii[WS(rs, 7)] = FMA(KP980785280, T9y, T9x);
							    ri[WS(rs, 11)] = FMA(KP831469612, T6X, T6U);
							    ri[WS(rs, 27)] = FNMS(KP831469612, T6X, T6U);
							    ri[WS(rs, 3)] = FMA(KP831469612, T6T, T6E);
							    ri[WS(rs, 19)] = FNMS(KP831469612, T6T, T6E);
						       }
						  }
						  T9t = FNMS(KP923879532, T9q, T9p);
						  T9r = FMA(KP923879532, T9q, T9p);
						  ri[WS(rs, 7)] = FMA(KP980785280, T79, T72);
						  ri[WS(rs, 23)] = FNMS(KP980785280, T79, T72);
						  ii[WS(rs, 19)] = FNMS(KP831469612, T9s, T9r);
						  ii[WS(rs, 3)] = FMA(KP831469612, T9s, T9r);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       ii[WS(rs, 27)] = FNMS(KP831469612, T9u, T9t);
	       ii[WS(rs, 11)] = FMA(KP831469612, T9u, T9t);
	       ri[WS(rs, 31)] = FMA(KP980785280, T7d, T7a);
	       ri[WS(rs, 15)] = FNMS(KP980785280, T7d, T7a);
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 27},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 32, "t2_32", twinstr, &GENUS, {236, 98, 252, 0}, 0, 0, 0 };

void X(codelet_t2_32) (planner *p) {
     X(kdft_dit_register) (p, t2_32, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle.native -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 32 -name t2_32 -include t.h */

/*
 * This function contains 488 FP additions, 280 FP multiplications,
 * (or, 376 additions, 168 multiplications, 112 fused multiply/add),
 * 158 stack variables, 7 constants, and 128 memory accesses
 */
#include "t.h"

static void t2_32(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + (mb * 8); m < me; m = m + 1, ri = ri + ms, ii = ii + ms, W = W + 8, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T2, T6, T3, T5, T8, TM, TO, Td, T9, Th, Tl, Te, TD, TH, T1y;
	       E T1H, T15, T1A, T11, T1F, T1n, T1p, T2q, T2I, T2u, T2K, T2V, T3b, T2Z, T3d;
	       E Tu, Ty, T3l, T3n, T1t, T1v, T2f, T2h, T1a, T1e, T32, T34, T1W, T1Y, T2C;
	       E T2E, Tg, TR, Tk, TS, Tm, TV, To, TT, T1M, T21, T1P, T22, T1Q, T25;
	       E T1S, T23;
	       {
		    E Ts, T1d, Tx, T18, TB, T14, TG, TZ, TC, T13, TF, T10, Tt, T1c, Tw;
		    E T19;
		    {
			 E T4, Tc, T7, Tb;
			 T2 = W[0];
			 T6 = W[3];
			 T3 = W[2];
			 T5 = W[1];
			 T4 = T2 * T3;
			 Tc = T5 * T3;
			 T7 = T5 * T6;
			 Tb = T2 * T6;
			 T8 = T4 + T7;
			 TM = T4 - T7;
			 TO = Tb + Tc;
			 Td = Tb - Tc;
			 T9 = W[4];
			 Ts = T2 * T9;
			 T1d = T6 * T9;
			 Tx = T5 * T9;
			 T18 = T3 * T9;
			 Th = W[6];
			 TB = T3 * Th;
			 T14 = T5 * Th;
			 TG = T6 * Th;
			 TZ = T2 * Th;
			 Tl = W[7];
			 TC = T6 * Tl;
			 T13 = T2 * Tl;
			 TF = T3 * Tl;
			 T10 = T5 * Tl;
			 Te = W[5];
			 Tt = T5 * Te;
			 T1c = T3 * Te;
			 Tw = T2 * Te;
			 T19 = T6 * Te;
		    }
		    TD = TB + TC;
		    TH = TF - TG;
		    T1y = TZ + T10;
		    T1H = TF + TG;
		    T15 = T13 + T14;
		    T1A = T13 - T14;
		    T11 = TZ - T10;
		    T1F = TB - TC;
		    T1n = FMA(T9, Th, Te * Tl);
		    T1p = FNMS(Te, Th, T9 * Tl);
		    {
			 E T2o, T2p, T2s, T2t;
			 T2o = T8 * Th;
			 T2p = Td * Tl;
			 T2q = T2o + T2p;
			 T2I = T2o - T2p;
			 T2s = T8 * Tl;
			 T2t = Td * Th;
			 T2u = T2s - T2t;
			 T2K = T2s + T2t;
		    }
		    {
			 E T2T, T2U, T2X, T2Y;
			 T2T = TM * Th;
			 T2U = TO * Tl;
			 T2V = T2T - T2U;
			 T3b = T2T + T2U;
			 T2X = TM * Tl;
			 T2Y = TO * Th;
			 T2Z = T2X + T2Y;
			 T3d = T2X - T2Y;
			 Tu = Ts + Tt;
			 Ty = Tw - Tx;
			 T3l = FMA(Tu, Th, Ty * Tl);
			 T3n = FNMS(Ty, Th, Tu * Tl);
		    }
		    T1t = Ts - Tt;
		    T1v = Tw + Tx;
		    T2f = FMA(T1t, Th, T1v * Tl);
		    T2h = FNMS(T1v, Th, T1t * Tl);
		    T1a = T18 - T19;
		    T1e = T1c + T1d;
		    T32 = FMA(T1a, Th, T1e * Tl);
		    T34 = FNMS(T1e, Th, T1a * Tl);
		    T1W = T18 + T19;
		    T1Y = T1c - T1d;
		    T2C = FMA(T1W, Th, T1Y * Tl);
		    T2E = FNMS(T1Y, Th, T1W * Tl);
		    {
			 E Ta, Tf, Ti, Tj;
			 Ta = T8 * T9;
			 Tf = Td * Te;
			 Tg = Ta - Tf;
			 TR = Ta + Tf;
			 Ti = T8 * Te;
			 Tj = Td * T9;
			 Tk = Ti + Tj;
			 TS = Ti - Tj;
		    }
		    Tm = FMA(Tg, Th, Tk * Tl);
		    TV = FNMS(TS, Th, TR * Tl);
		    To = FNMS(Tk, Th, Tg * Tl);
		    TT = FMA(TR, Th, TS * Tl);
		    {
			 E T1K, T1L, T1N, T1O;
			 T1K = TM * T9;
			 T1L = TO * Te;
			 T1M = T1K - T1L;
			 T21 = T1K + T1L;
			 T1N = TM * Te;
			 T1O = TO * T9;
			 T1P = T1N + T1O;
			 T22 = T1N - T1O;
		    }
		    T1Q = FMA(T1M, Th, T1P * Tl);
		    T25 = FNMS(T22, Th, T21 * Tl);
		    T1S = FNMS(T1P, Th, T1M * Tl);
		    T23 = FMA(T21, Th, T22 * Tl);
	       }
	       {
		    E TL, T6f, T8c, T8q, T3F, T5t, T7I, T7W, T2y, T6B, T6y, T7j, T4k, T5J, T4B;
		    E T5G, T3h, T6H, T6O, T7o, T4L, T5N, T52, T5Q, T1i, T7V, T6i, T7D, T3K, T5u;
		    E T3P, T5v, T1E, T6n, T6m, T7e, T3W, T5y, T41, T5z, T29, T6p, T6s, T7f, T47;
		    E T5B, T4c, T5C, T2R, T6z, T6E, T7k, T4v, T5H, T4E, T5K, T3y, T6P, T6K, T7p;
		    E T4W, T5R, T55, T5O;
		    {
			 E T1, T7G, Tq, T7F, TA, T3C, TJ, T3D, Tn, Tp;
			 T1 = ri[0];
			 T7G = ii[0];
			 Tn = ri[WS(rs, 16)];
			 Tp = ii[WS(rs, 16)];
			 Tq = FMA(Tm, Tn, To * Tp);
			 T7F = FNMS(To, Tn, Tm * Tp);
			 {
			      E Tv, Tz, TE, TI;
			      Tv = ri[WS(rs, 8)];
			      Tz = ii[WS(rs, 8)];
			      TA = FMA(Tu, Tv, Ty * Tz);
			      T3C = FNMS(Ty, Tv, Tu * Tz);
			      TE = ri[WS(rs, 24)];
			      TI = ii[WS(rs, 24)];
			      TJ = FMA(TD, TE, TH * TI);
			      T3D = FNMS(TH, TE, TD * TI);
			 }
			 {
			      E Tr, TK, T8a, T8b;
			      Tr = T1 + Tq;
			      TK = TA + TJ;
			      TL = Tr + TK;
			      T6f = Tr - TK;
			      T8a = T7G - T7F;
			      T8b = TA - TJ;
			      T8c = T8a - T8b;
			      T8q = T8b + T8a;
			 }
			 {
			      E T3B, T3E, T7E, T7H;
			      T3B = T1 - Tq;
			      T3E = T3C - T3D;
			      T3F = T3B - T3E;
			      T5t = T3B + T3E;
			      T7E = T3C + T3D;
			      T7H = T7F + T7G;
			      T7I = T7E + T7H;
			      T7W = T7H - T7E;
			 }
		    }
		    {
			 E T2e, T4g, T2w, T4z, T2j, T4h, T2n, T4y;
			 {
			      E T2c, T2d, T2r, T2v;
			      T2c = ri[WS(rs, 1)];
			      T2d = ii[WS(rs, 1)];
			      T2e = FMA(T2, T2c, T5 * T2d);
			      T4g = FNMS(T5, T2c, T2 * T2d);
			      T2r = ri[WS(rs, 25)];
			      T2v = ii[WS(rs, 25)];
			      T2w = FMA(T2q, T2r, T2u * T2v);
			      T4z = FNMS(T2u, T2r, T2q * T2v);
			 }
			 {
			      E T2g, T2i, T2l, T2m;
			      T2g = ri[WS(rs, 17)];
			      T2i = ii[WS(rs, 17)];
			      T2j = FMA(T2f, T2g, T2h * T2i);
			      T4h = FNMS(T2h, T2g, T2f * T2i);
			      T2l = ri[WS(rs, 9)];
			      T2m = ii[WS(rs, 9)];
			      T2n = FMA(T9, T2l, Te * T2m);
			      T4y = FNMS(Te, T2l, T9 * T2m);
			 }
			 {
			      E T2k, T2x, T6w, T6x;
			      T2k = T2e + T2j;
			      T2x = T2n + T2w;
			      T2y = T2k + T2x;
			      T6B = T2k - T2x;
			      T6w = T4g + T4h;
			      T6x = T4y + T4z;
			      T6y = T6w - T6x;
			      T7j = T6w + T6x;
			 }
			 {
			      E T4i, T4j, T4x, T4A;
			      T4i = T4g - T4h;
			      T4j = T2n - T2w;
			      T4k = T4i + T4j;
			      T5J = T4i - T4j;
			      T4x = T2e - T2j;
			      T4A = T4y - T4z;
			      T4B = T4x - T4A;
			      T5G = T4x + T4A;
			 }
		    }
		    {
			 E T31, T4Y, T3f, T4J, T36, T4Z, T3a, T4I;
			 {
			      E T2W, T30, T3c, T3e;
			      T2W = ri[WS(rs, 31)];
			      T30 = ii[WS(rs, 31)];
			      T31 = FMA(T2V, T2W, T2Z * T30);
			      T4Y = FNMS(T2Z, T2W, T2V * T30);
			      T3c = ri[WS(rs, 23)];
			      T3e = ii[WS(rs, 23)];
			      T3f = FMA(T3b, T3c, T3d * T3e);
			      T4J = FNMS(T3d, T3c, T3b * T3e);
			 }
			 {
			      E T33, T35, T38, T39;
			      T33 = ri[WS(rs, 15)];
			      T35 = ii[WS(rs, 15)];
			      T36 = FMA(T32, T33, T34 * T35);
			      T4Z = FNMS(T34, T33, T32 * T35);
			      T38 = ri[WS(rs, 7)];
			      T39 = ii[WS(rs, 7)];
			      T3a = FMA(TR, T38, TS * T39);
			      T4I = FNMS(TS, T38, TR * T39);
			 }
			 {
			      E T37, T3g, T6M, T6N;
			      T37 = T31 + T36;
			      T3g = T3a + T3f;
			      T3h = T37 + T3g;
			      T6H = T37 - T3g;
			      T6M = T4Y + T4Z;
			      T6N = T4I + T4J;
			      T6O = T6M - T6N;
			      T7o = T6M + T6N;
			 }
			 {
			      E T4H, T4K, T50, T51;
			      T4H = T31 - T36;
			      T4K = T4I - T4J;
			      T4L = T4H - T4K;
			      T5N = T4H + T4K;
			      T50 = T4Y - T4Z;
			      T51 = T3a - T3f;
			      T52 = T50 + T51;
			      T5Q = T50 - T51;
			 }
		    }
		    {
			 E TQ, T3G, T1g, T3N, TX, T3H, T17, T3M;
			 {
			      E TN, TP, T1b, T1f;
			      TN = ri[WS(rs, 4)];
			      TP = ii[WS(rs, 4)];
			      TQ = FMA(TM, TN, TO * TP);
			      T3G = FNMS(TO, TN, TM * TP);
			      T1b = ri[WS(rs, 12)];
			      T1f = ii[WS(rs, 12)];
			      T1g = FMA(T1a, T1b, T1e * T1f);
			      T3N = FNMS(T1e, T1b, T1a * T1f);
			 }
			 {
			      E TU, TW, T12, T16;
			      TU = ri[WS(rs, 20)];
			      TW = ii[WS(rs, 20)];
			      TX = FMA(TT, TU, TV * TW);
			      T3H = FNMS(TV, TU, TT * TW);
			      T12 = ri[WS(rs, 28)];
			      T16 = ii[WS(rs, 28)];
			      T17 = FMA(T11, T12, T15 * T16);
			      T3M = FNMS(T15, T12, T11 * T16);
			 }
			 {
			      E TY, T1h, T6g, T6h;
			      TY = TQ + TX;
			      T1h = T17 + T1g;
			      T1i = TY + T1h;
			      T7V = T1h - TY;
			      T6g = T3G + T3H;
			      T6h = T3M + T3N;
			      T6i = T6g - T6h;
			      T7D = T6g + T6h;
			 }
			 {
			      E T3I, T3J, T3L, T3O;
			      T3I = T3G - T3H;
			      T3J = TQ - TX;
			      T3K = T3I - T3J;
			      T5u = T3J + T3I;
			      T3L = T17 - T1g;
			      T3O = T3M - T3N;
			      T3P = T3L + T3O;
			      T5v = T3L - T3O;
			 }
		    }
		    {
			 E T1m, T3S, T1C, T3Z, T1r, T3T, T1x, T3Y;
			 {
			      E T1k, T1l, T1z, T1B;
			      T1k = ri[WS(rs, 2)];
			      T1l = ii[WS(rs, 2)];
			      T1m = FMA(T8, T1k, Td * T1l);
			      T3S = FNMS(Td, T1k, T8 * T1l);
			      T1z = ri[WS(rs, 26)];
			      T1B = ii[WS(rs, 26)];
			      T1C = FMA(T1y, T1z, T1A * T1B);
			      T3Z = FNMS(T1A, T1z, T1y * T1B);
			 }
			 {
			      E T1o, T1q, T1u, T1w;
			      T1o = ri[WS(rs, 18)];
			      T1q = ii[WS(rs, 18)];
			      T1r = FMA(T1n, T1o, T1p * T1q);
			      T3T = FNMS(T1p, T1o, T1n * T1q);
			      T1u = ri[WS(rs, 10)];
			      T1w = ii[WS(rs, 10)];
			      T1x = FMA(T1t, T1u, T1v * T1w);
			      T3Y = FNMS(T1v, T1u, T1t * T1w);
			 }
			 {
			      E T1s, T1D, T6k, T6l;
			      T1s = T1m + T1r;
			      T1D = T1x + T1C;
			      T1E = T1s + T1D;
			      T6n = T1s - T1D;
			      T6k = T3S + T3T;
			      T6l = T3Y + T3Z;
			      T6m = T6k - T6l;
			      T7e = T6k + T6l;
			 }
			 {
			      E T3U, T3V, T3X, T40;
			      T3U = T3S - T3T;
			      T3V = T1x - T1C;
			      T3W = T3U + T3V;
			      T5y = T3U - T3V;
			      T3X = T1m - T1r;
			      T40 = T3Y - T3Z;
			      T41 = T3X - T40;
			      T5z = T3X + T40;
			 }
		    }
		    {
			 E T1J, T43, T27, T4a, T1U, T44, T20, T49;
			 {
			      E T1G, T1I, T24, T26;
			      T1G = ri[WS(rs, 30)];
			      T1I = ii[WS(rs, 30)];
			      T1J = FMA(T1F, T1G, T1H * T1I);
			      T43 = FNMS(T1H, T1G, T1F * T1I);
			      T24 = ri[WS(rs, 22)];
			      T26 = ii[WS(rs, 22)];
			      T27 = FMA(T23, T24, T25 * T26);
			      T4a = FNMS(T25, T24, T23 * T26);
			 }
			 {
			      E T1R, T1T, T1X, T1Z;
			      T1R = ri[WS(rs, 14)];
			      T1T = ii[WS(rs, 14)];
			      T1U = FMA(T1Q, T1R, T1S * T1T);
			      T44 = FNMS(T1S, T1R, T1Q * T1T);
			      T1X = ri[WS(rs, 6)];
			      T1Z = ii[WS(rs, 6)];
			      T20 = FMA(T1W, T1X, T1Y * T1Z);
			      T49 = FNMS(T1Y, T1X, T1W * T1Z);
			 }
			 {
			      E T1V, T28, T6q, T6r;
			      T1V = T1J + T1U;
			      T28 = T20 + T27;
			      T29 = T1V + T28;
			      T6p = T1V - T28;
			      T6q = T43 + T44;
			      T6r = T49 + T4a;
			      T6s = T6q - T6r;
			      T7f = T6q + T6r;
			 }
			 {
			      E T45, T46, T48, T4b;
			      T45 = T43 - T44;
			      T46 = T20 - T27;
			      T47 = T45 + T46;
			      T5B = T45 - T46;
			      T48 = T1J - T1U;
			      T4b = T49 - T4a;
			      T4c = T48 - T4b;
			      T5C = T48 + T4b;
			 }
		    }
		    {
			 E T2B, T4r, T2G, T4s, T4q, T4t, T2M, T4m, T2P, T4n, T4l, T4o;
			 {
			      E T2z, T2A, T2D, T2F;
			      T2z = ri[WS(rs, 5)];
			      T2A = ii[WS(rs, 5)];
			      T2B = FMA(T21, T2z, T22 * T2A);
			      T4r = FNMS(T22, T2z, T21 * T2A);
			      T2D = ri[WS(rs, 21)];
			      T2F = ii[WS(rs, 21)];
			      T2G = FMA(T2C, T2D, T2E * T2F);
			      T4s = FNMS(T2E, T2D, T2C * T2F);
			 }
			 T4q = T2B - T2G;
			 T4t = T4r - T4s;
			 {
			      E T2J, T2L, T2N, T2O;
			      T2J = ri[WS(rs, 29)];
			      T2L = ii[WS(rs, 29)];
			      T2M = FMA(T2I, T2J, T2K * T2L);
			      T4m = FNMS(T2K, T2J, T2I * T2L);
			      T2N = ri[WS(rs, 13)];
			      T2O = ii[WS(rs, 13)];
			      T2P = FMA(T1M, T2N, T1P * T2O);
			      T4n = FNMS(T1P, T2N, T1M * T2O);
			 }
			 T4l = T2M - T2P;
			 T4o = T4m - T4n;
			 {
			      E T2H, T2Q, T6C, T6D;
			      T2H = T2B + T2G;
			      T2Q = T2M + T2P;
			      T2R = T2H + T2Q;
			      T6z = T2Q - T2H;
			      T6C = T4r + T4s;
			      T6D = T4m + T4n;
			      T6E = T6C - T6D;
			      T7k = T6C + T6D;
			 }
			 {
			      E T4p, T4u, T4C, T4D;
			      T4p = T4l - T4o;
			      T4u = T4q + T4t;
			      T4v = KP707106781 * (T4p - T4u);
			      T5H = KP707106781 * (T4u + T4p);
			      T4C = T4t - T4q;
			      T4D = T4l + T4o;
			      T4E = KP707106781 * (T4C - T4D);
			      T5K = KP707106781 * (T4C + T4D);
			 }
		    }
		    {
			 E T3k, T4M, T3p, T4N, T4O, T4P, T3t, T4S, T3w, T4T, T4R, T4U;
			 {
			      E T3i, T3j, T3m, T3o;
			      T3i = ri[WS(rs, 3)];
			      T3j = ii[WS(rs, 3)];
			      T3k = FMA(T3, T3i, T6 * T3j);
			      T4M = FNMS(T6, T3i, T3 * T3j);
			      T3m = ri[WS(rs, 19)];
			      T3o = ii[WS(rs, 19)];
			      T3p = FMA(T3l, T3m, T3n * T3o);
			      T4N = FNMS(T3n, T3m, T3l * T3o);
			 }
			 T4O = T4M - T4N;
			 T4P = T3k - T3p;
			 {
			      E T3r, T3s, T3u, T3v;
			      T3r = ri[WS(rs, 27)];
			      T3s = ii[WS(rs, 27)];
			      T3t = FMA(Th, T3r, Tl * T3s);
			      T4S = FNMS(Tl, T3r, Th * T3s);
			      T3u = ri[WS(rs, 11)];
			      T3v = ii[WS(rs, 11)];
			      T3w = FMA(Tg, T3u, Tk * T3v);
			      T4T = FNMS(Tk, T3u, Tg * T3v);
			 }
			 T4R = T3t - T3w;
			 T4U = T4S - T4T;
			 {
			      E T3q, T3x, T6I, T6J;
			      T3q = T3k + T3p;
			      T3x = T3t + T3w;
			      T3y = T3q + T3x;
			      T6P = T3x - T3q;
			      T6I = T4M + T4N;
			      T6J = T4S + T4T;
			      T6K = T6I - T6J;
			      T7p = T6I + T6J;
			 }
			 {
			      E T4Q, T4V, T53, T54;
			      T4Q = T4O - T4P;
			      T4V = T4R + T4U;
			      T4W = KP707106781 * (T4Q - T4V);
			      T5R = KP707106781 * (T4Q + T4V);
			      T53 = T4R - T4U;
			      T54 = T4P + T4O;
			      T55 = KP707106781 * (T53 - T54);
			      T5O = KP707106781 * (T54 + T53);
			 }
		    }
		    {
			 E T2b, T7x, T7K, T7M, T3A, T7L, T7A, T7B;
			 {
			      E T1j, T2a, T7C, T7J;
			      T1j = TL + T1i;
			      T2a = T1E + T29;
			      T2b = T1j + T2a;
			      T7x = T1j - T2a;
			      T7C = T7e + T7f;
			      T7J = T7D + T7I;
			      T7K = T7C + T7J;
			      T7M = T7J - T7C;
			 }
			 {
			      E T2S, T3z, T7y, T7z;
			      T2S = T2y + T2R;
			      T3z = T3h + T3y;
			      T3A = T2S + T3z;
			      T7L = T3z - T2S;
			      T7y = T7j + T7k;
			      T7z = T7o + T7p;
			      T7A = T7y - T7z;
			      T7B = T7y + T7z;
			 }
			 ri[WS(rs, 16)] = T2b - T3A;
			 ii[WS(rs, 8)] = T7L + T7M;
			 ii[WS(rs, 24)] = T7M - T7L;
			 ri[0] = T2b + T3A;
			 ri[WS(rs, 24)] = T7x - T7A;
			 ii[0] = T7B + T7K;
			 ii[WS(rs, 16)] = T7K - T7B;
			 ri[WS(rs, 8)] = T7x + T7A;
		    }
		    {
			 E T7h, T7t, T7Q, T7S, T7m, T7u, T7r, T7v;
			 {
			      E T7d, T7g, T7O, T7P;
			      T7d = TL - T1i;
			      T7g = T7e - T7f;
			      T7h = T7d + T7g;
			      T7t = T7d - T7g;
			      T7O = T29 - T1E;
			      T7P = T7I - T7D;
			      T7Q = T7O + T7P;
			      T7S = T7P - T7O;
			 }
			 {
			      E T7i, T7l, T7n, T7q;
			      T7i = T2y - T2R;
			      T7l = T7j - T7k;
			      T7m = T7i + T7l;
			      T7u = T7l - T7i;
			      T7n = T3h - T3y;
			      T7q = T7o - T7p;
			      T7r = T7n - T7q;
			      T7v = T7n + T7q;
			 }
			 {
			      E T7s, T7R, T7w, T7N;
			      T7s = KP707106781 * (T7m + T7r);
			      ri[WS(rs, 20)] = T7h - T7s;
			      ri[WS(rs, 4)] = T7h + T7s;
			      T7R = KP707106781 * (T7r - T7m);
			      ii[WS(rs, 12)] = T7R + T7S;
			      ii[WS(rs, 28)] = T7S - T7R;
			      T7w = KP707106781 * (T7u - T7v);
			      ri[WS(rs, 28)] = T7t - T7w;
			      ri[WS(rs, 12)] = T7t + T7w;
			      T7N = KP707106781 * (T7u + T7v);
			      ii[WS(rs, 4)] = T7N + T7Q;
			      ii[WS(rs, 20)] = T7Q - T7N;
			 }
		    }
		    {
			 E T6j, T7X, T83, T6X, T6u, T7U, T77, T7b, T70, T82, T6G, T6U, T74, T7a, T6R;
			 E T6V;
			 {
			      E T6o, T6t, T6A, T6F;
			      T6j = T6f - T6i;
			      T7X = T7V + T7W;
			      T83 = T7W - T7V;
			      T6X = T6f + T6i;
			      T6o = T6m - T6n;
			      T6t = T6p + T6s;
			      T6u = KP707106781 * (T6o - T6t);
			      T7U = KP707106781 * (T6o + T6t);
			      {
				   E T75, T76, T6Y, T6Z;
				   T75 = T6H + T6K;
				   T76 = T6O + T6P;
				   T77 = FNMS(KP382683432, T76, KP923879532 * T75);
				   T7b = FMA(KP923879532, T76, KP382683432 * T75);
				   T6Y = T6n + T6m;
				   T6Z = T6p - T6s;
				   T70 = KP707106781 * (T6Y + T6Z);
				   T82 = KP707106781 * (T6Z - T6Y);
			      }
			      T6A = T6y - T6z;
			      T6F = T6B - T6E;
			      T6G = FMA(KP923879532, T6A, KP382683432 * T6F);
			      T6U = FNMS(KP923879532, T6F, KP382683432 * T6A);
			      {
				   E T72, T73, T6L, T6Q;
				   T72 = T6y + T6z;
				   T73 = T6B + T6E;
				   T74 = FMA(KP382683432, T72, KP923879532 * T73);
				   T7a = FNMS(KP382683432, T73, KP923879532 * T72);
				   T6L = T6H - T6K;
				   T6Q = T6O - T6P;
				   T6R = FNMS(KP923879532, T6Q, KP382683432 * T6L);
				   T6V = FMA(KP382683432, T6Q, KP923879532 * T6L);
			      }
			 }
			 {
			      E T6v, T6S, T81, T84;
			      T6v = T6j + T6u;
			      T6S = T6G + T6R;
			      ri[WS(rs, 22)] = T6v - T6S;
			      ri[WS(rs, 6)] = T6v + T6S;
			      T81 = T6U + T6V;
			      T84 = T82 + T83;
			      ii[WS(rs, 6)] = T81 + T84;
			      ii[WS(rs, 22)] = T84 - T81;
			 }
			 {
			      E T85, T86, T6T, T6W;
			      T85 = T6R - T6G;
			      T86 = T83 - T82;
			      ii[WS(rs, 14)] = T85 + T86;
			      ii[WS(rs, 30)] = T86 - T85;
			      T6T = T6j - T6u;
			      T6W = T6U - T6V;
			      ri[WS(rs, 30)] = T6T - T6W;
			      ri[WS(rs, 14)] = T6T + T6W;
			 }
			 {
			      E T71, T78, T7T, T7Y;
			      T71 = T6X + T70;
			      T78 = T74 + T77;
			      ri[WS(rs, 18)] = T71 - T78;
			      ri[WS(rs, 2)] = T71 + T78;
			      T7T = T7a + T7b;
			      T7Y = T7U + T7X;
			      ii[WS(rs, 2)] = T7T + T7Y;
			      ii[WS(rs, 18)] = T7Y - T7T;
			 }
			 {
			      E T7Z, T80, T79, T7c;
			      T7Z = T77 - T74;
			      T80 = T7X - T7U;
			      ii[WS(rs, 10)] = T7Z + T80;
			      ii[WS(rs, 26)] = T80 - T7Z;
			      T79 = T6X - T70;
			      T7c = T7a - T7b;
			      ri[WS(rs, 26)] = T79 - T7c;
			      ri[WS(rs, 10)] = T79 + T7c;
			 }
		    }
		    {
			 E T3R, T5d, T8r, T8x, T4e, T8o, T5n, T5r, T4G, T5a, T5g, T8w, T5k, T5q, T57;
			 E T5b, T3Q, T8p;
			 T3Q = KP707106781 * (T3K - T3P);
			 T3R = T3F - T3Q;
			 T5d = T3F + T3Q;
			 T8p = KP707106781 * (T5v - T5u);
			 T8r = T8p + T8q;
			 T8x = T8q - T8p;
			 {
			      E T42, T4d, T5l, T5m;
			      T42 = FNMS(KP923879532, T41, KP382683432 * T3W);
			      T4d = FMA(KP382683432, T47, KP923879532 * T4c);
			      T4e = T42 - T4d;
			      T8o = T42 + T4d;
			      T5l = T4L + T4W;
			      T5m = T52 + T55;
			      T5n = FNMS(KP555570233, T5m, KP831469612 * T5l);
			      T5r = FMA(KP831469612, T5m, KP555570233 * T5l);
			 }
			 {
			      E T4w, T4F, T5e, T5f;
			      T4w = T4k - T4v;
			      T4F = T4B - T4E;
			      T4G = FMA(KP980785280, T4w, KP195090322 * T4F);
			      T5a = FNMS(KP980785280, T4F, KP195090322 * T4w);
			      T5e = FMA(KP923879532, T3W, KP382683432 * T41);
			      T5f = FNMS(KP923879532, T47, KP382683432 * T4c);
			      T5g = T5e + T5f;
			      T8w = T5f - T5e;
			 }
			 {
			      E T5i, T5j, T4X, T56;
			      T5i = T4k + T4v;
			      T5j = T4B + T4E;
			      T5k = FMA(KP555570233, T5i, KP831469612 * T5j);
			      T5q = FNMS(KP555570233, T5j, KP831469612 * T5i);
			      T4X = T4L - T4W;
			      T56 = T52 - T55;
			      T57 = FNMS(KP980785280, T56, KP195090322 * T4X);
			      T5b = FMA(KP195090322, T56, KP980785280 * T4X);
			 }
			 {
			      E T4f, T58, T8v, T8y;
			      T4f = T3R + T4e;
			      T58 = T4G + T57;
			      ri[WS(rs, 23)] = T4f - T58;
			      ri[WS(rs, 7)] = T4f + T58;
			      T8v = T5a + T5b;
			      T8y = T8w + T8x;
			      ii[WS(rs, 7)] = T8v + T8y;
			      ii[WS(rs, 23)] = T8y - T8v;
			 }
			 {
			      E T8z, T8A, T59, T5c;
			      T8z = T57 - T4G;
			      T8A = T8x - T8w;
			      ii[WS(rs, 15)] = T8z + T8A;
			      ii[WS(rs, 31)] = T8A - T8z;
			      T59 = T3R - T4e;
			      T5c = T5a - T5b;
			      ri[WS(rs, 31)] = T59 - T5c;
			      ri[WS(rs, 15)] = T59 + T5c;
			 }
			 {
			      E T5h, T5o, T8n, T8s;
			      T5h = T5d + T5g;
			      T5o = T5k + T5n;
			      ri[WS(rs, 19)] = T5h - T5o;
			      ri[WS(rs, 3)] = T5h + T5o;
			      T8n = T5q + T5r;
			      T8s = T8o + T8r;
			      ii[WS(rs, 3)] = T8n + T8s;
			      ii[WS(rs, 19)] = T8s - T8n;
			 }
			 {
			      E T8t, T8u, T5p, T5s;
			      T8t = T5n - T5k;
			      T8u = T8r - T8o;
			      ii[WS(rs, 11)] = T8t + T8u;
			      ii[WS(rs, 27)] = T8u - T8t;
			      T5p = T5d - T5g;
			      T5s = T5q - T5r;
			      ri[WS(rs, 27)] = T5p - T5s;
			      ri[WS(rs, 11)] = T5p + T5s;
			 }
		    }
		    {
			 E T5x, T5Z, T8d, T8j, T5E, T88, T69, T6d, T5M, T5W, T62, T8i, T66, T6c, T5T;
			 E T5X, T5w, T89;
			 T5w = KP707106781 * (T5u + T5v);
			 T5x = T5t - T5w;
			 T5Z = T5t + T5w;
			 T89 = KP707106781 * (T3K + T3P);
			 T8d = T89 + T8c;
			 T8j = T8c - T89;
			 {
			      E T5A, T5D, T67, T68;
			      T5A = FNMS(KP382683432, T5z, KP923879532 * T5y);
			      T5D = FMA(KP923879532, T5B, KP382683432 * T5C);
			      T5E = T5A - T5D;
			      T88 = T5A + T5D;
			      T67 = T5N + T5O;
			      T68 = T5Q + T5R;
			      T69 = FNMS(KP195090322, T68, KP980785280 * T67);
			      T6d = FMA(KP195090322, T67, KP980785280 * T68);
			 }
			 {
			      E T5I, T5L, T60, T61;
			      T5I = T5G - T5H;
			      T5L = T5J - T5K;
			      T5M = FMA(KP555570233, T5I, KP831469612 * T5L);
			      T5W = FNMS(KP831469612, T5I, KP555570233 * T5L);
			      T60 = FMA(KP382683432, T5y, KP923879532 * T5z);
			      T61 = FNMS(KP382683432, T5B, KP923879532 * T5C);
			      T62 = T60 + T61;
			      T8i = T61 - T60;
			 }
			 {
			      E T64, T65, T5P, T5S;
			      T64 = T5G + T5H;
			      T65 = T5J + T5K;
			      T66 = FMA(KP980785280, T64, KP195090322 * T65);
			      T6c = FNMS(KP195090322, T64, KP980785280 * T65);
			      T5P = T5N - T5O;
			      T5S = T5Q - T5R;
			      T5T = FNMS(KP831469612, T5S, KP555570233 * T5P);
			      T5X = FMA(KP831469612, T5P, KP555570233 * T5S);
			 }
			 {
			      E T5F, T5U, T8h, T8k;
			      T5F = T5x + T5E;
			      T5U = T5M + T5T;
			      ri[WS(rs, 21)] = T5F - T5U;
			      ri[WS(rs, 5)] = T5F + T5U;
			      T8h = T5W + T5X;
			      T8k = T8i + T8j;
			      ii[WS(rs, 5)] = T8h + T8k;
			      ii[WS(rs, 21)] = T8k - T8h;
			 }
			 {
			      E T8l, T8m, T5V, T5Y;
			      T8l = T5T - T5M;
			      T8m = T8j - T8i;
			      ii[WS(rs, 13)] = T8l + T8m;
			      ii[WS(rs, 29)] = T8m - T8l;
			      T5V = T5x - T5E;
			      T5Y = T5W - T5X;
			      ri[WS(rs, 29)] = T5V - T5Y;
			      ri[WS(rs, 13)] = T5V + T5Y;
			 }
			 {
			      E T63, T6a, T87, T8e;
			      T63 = T5Z + T62;
			      T6a = T66 + T69;
			      ri[WS(rs, 17)] = T63 - T6a;
			      ri[WS(rs, 1)] = T63 + T6a;
			      T87 = T6c + T6d;
			      T8e = T88 + T8d;
			      ii[WS(rs, 1)] = T87 + T8e;
			      ii[WS(rs, 17)] = T8e - T87;
			 }
			 {
			      E T8f, T8g, T6b, T6e;
			      T8f = T69 - T66;
			      T8g = T8d - T88;
			      ii[WS(rs, 9)] = T8f + T8g;
			      ii[WS(rs, 25)] = T8g - T8f;
			      T6b = T5Z - T62;
			      T6e = T6c - T6d;
			      ri[WS(rs, 25)] = T6b - T6e;
			      ri[WS(rs, 9)] = T6b + T6e;
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 27},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 32, "t2_32", twinstr, &GENUS, {376, 168, 112, 0}, 0, 0, 0 };

void X(codelet_t2_32) (planner *p) {
     X(kdft_dit_register) (p, t2_32, &desc);
}
#endif				/* HAVE_FMA */
